'''
Copyright 2014 Cisco Systems, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

'''

from UcsSdk import *
from base64 import b64encode


class UcsNagiosGetEquipmentDetails:
    '''
    classdocs
    '''
    def __init__(self, ucs_handle):
        '''
        Constructor
        '''
        username = str(ucs_handle._username)
        if username.find('\\') != -1:
            username = username.replace("\\",r"\\")
        self.user_password_string = "\""+username+"\""+"!"+"\""+\
        b64encode(ucs_handle._password)+"\""+"!"+"\""

        self.service_cmd_for_class="check_cisco_ucs!"+\
        self.user_password_string+"class"+"\""+"!"+"\""

        self.service_cmd_for_dn="check_cisco_ucs!"+\
        self.user_password_string+"dn"+"\""+"!"+"\""

    def create_ucs_service_for_class(self, service_name, class_id, dn) :
        service_list = []
        service_cmd =self.service_cmd_for_class+class_id + "\"" + " --filter dn:" + dn
        action_cmd= "&" + self.user_password_string + "&" + "dn:" + dn
        service_list.append([service_name,service_cmd,action_cmd])
        return service_list

    def create_ucs_service_for_dn(self,service_name,dn) :
        service_list = []

        service_cmd = self.service_cmd_for_dn+dn+"\""
        service_list.append([service_name, service_cmd])
        return service_list

    def create_ucs_service(self, service_name, service_type, dn):
        if (re.search("/", service_type) or (service_type.strip() == "sys")):
            # DN
            return self.create_ucs_service_for_dn(service_name, service_type)
        else:
            # Class
            return self.create_ucs_service_for_class(service_name, service_type, dn)
    
