# $Id: Request.pm 42143 2014-09-03 14:06:15Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Request.pm $

package UvT::Kiki::WS::Person::Request;

use UvT::Kiki::WS::Request -self;

field anr => sub {
	my $self = shift;
	my (undef, $anr) = @{$self->pairs};
	die "Malformed value '$anr' for field 'anr'\n"
		if defined $anr && $anr !~ /^[0-9]{6}$/a;
	return int($anr);
};

field old_person => sub {
	my $new_person = shift->new_person;
	return $new_person ? $new_person->original : undef;
};

field new_person => sub {
	my $self = shift;
	my $anr = $self->anr;
	die "anr required\n" unless defined $anr;
	return $self->db->person_for_anr($anr);
};
