# $Id: Request.pm 46832 2017-08-01 11:08:55Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Delete/Request.pm $

package UvT::Kiki::WS::Person::Delete::Request;

use UvT::Kiki::WS::Person::Request -self;

field note => sub { shift->new_person; return };

field new_person => sub {
	my $self = shift;

	my $person = super;

	if($self->nonce) {
		if($self->is_robot) {
			if($person) {
				my $original = $person->original;
				my $note = $person->remove;
				$self->note($note);

				if($note->[0] eq 'ok') {
					my $what = $self->is_robot ? "Robot" : "User";
					my $who = $self->login;
					my $old = $original->toString;
					my $text = "$what $who deleted person:\n\told: $old\n";
					warn $text;

					my $full = $original->full;
					my $anr = sprintf('%06d', $original->anr);
					$self->mailtje("[kiki] $who deleted $full ($anr)", $original->diff);
					$self->activate;
				}
			} else {
				$self->note([ok => 'non-existent']);
			}
		} else {
			$self->note([error => 'no-robot']);
		}
	} else {
		$self->note([error => 'session']);
	}

	return $person;
}
