# $Id: Domain.pm 41867 2014-07-03 15:23:19Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Database/Domain.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Database::Domain;

use Clarity -self;

field db;

field id;
field names;

sub same {
	my $name = lc(shift);
	return scalar grep { lc($_) eq $name } @{$self->names};
}

sub name {
	return $self->names->[0];
}

sub full {
	return $self->names->[0];
}

sub toString {
	my $names = $self->names;
	if(@$names > 1) {
		return $names->[0].' ('.join(', ', @$names[1..$#$names]).')';
	} else {
		return $names->[0];
	}
}

sub TO_JSON {
	return $self->names;
}
