# $Id: Request.pm 42140 2014-09-03 12:19:40Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Alias/Request.pm $

package UvT::Kiki::WS::Alias::Request;

use UvT::Kiki::WS::Request -self;

field address => sub {
	my $self = shift;
	my (undef, $address) = @{$self->pairs};
	die "Malformed value '$address' for field 'address'\n"
		if defined $address && $address !~ /^[^@]+\@[^@]+$/;
	return $address;
};

field old_alias => sub { shift->new_alias->original };

field new_alias => sub {
	my $self = shift;
	my $address = $self->address;
	return $self->db->new_alias unless defined $address;
	my $alias = $self->db->fetch_alias($address);
	die "Unknown alias '$address'\n" unless defined $alias;
	return $alias;
};
